extends KinematicBody

onready var WheelFrontRight = $RootNode/race/wheelFrontRight
onready var WheelFrontLeft = $RootNode/race/wheelFrontLeft

# Paramètres
var vitesse_max = 17.5
var acceleration = 10.0
var frein = 20.0
var rotation_vitesse = 2.0
var gravity = 9.8
var vertical_velocity = 0.0

# Angle de braquage des roues
var max_steering_angle = 30.0 # en degrés
var current_steering_angle = 0.0
var steering_speed = 100.0 # vitesse de rotation en degrés/sec

# Internes
var velocity = Vector3.ZERO
var direction = Vector3.ZERO

func _physics_process(delta):
	direction = Vector3.ZERO

	# Entrées clavier (avance/recul)
	if Input.is_action_pressed("ui_up"):
		direction.z -= 1
	elif Input.is_action_pressed("ui_down"):
		direction.z += 1

	# Rotation du véhicule
	if Input.is_action_pressed("ui_right"):
		rotate_y(-rotation_vitesse * delta)
		current_steering_angle = lerp(current_steering_angle, -max_steering_angle, steering_speed * delta / max_steering_angle)
	elif Input.is_action_pressed("ui_left"):
		rotate_y(rotation_vitesse * delta)
		current_steering_angle = lerp(current_steering_angle, max_steering_angle, steering_speed * delta / max_steering_angle)
	else:
		# Revenir à zéro si aucune touche n'est pressée
		current_steering_angle = lerp(current_steering_angle, 0.0, steering_speed * delta / max_steering_angle)

	# Appliquer la rotation aux roues avant (en local)
	WheelFrontLeft.rotation.y = deg2rad(current_steering_angle)
	WheelFrontRight.rotation.y = deg2rad(current_steering_angle)

	direction = direction.normalized()

	# Avance selon la direction actuelle du véhicule
	var target_velocity = transform.basis.z * direction.z * -vitesse_max
	velocity = velocity.linear_interpolate(target_velocity, acceleration * delta)

	# Frein automatique
	if direction == Vector3.ZERO:
		velocity = velocity.linear_interpolate(Vector3.ZERO, frein * delta)

	# Gravité
	if not is_on_floor():
		vertical_velocity -= gravity * delta
	else:
		vertical_velocity = 0.0

	velocity.y = vertical_velocity

	velocity = move_and_slide(velocity, Vector3.UP)
